<?php

namespace App\Http\Controllers\Admin;

use App\Models\ContactEmail;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Admin\ContactEmailRequest;

use A17\Twill\Http\Controllers\Admin\ModuleController;

class ContactEmailController extends ModuleController
{
    protected $moduleName = 'contactEmails';
    
    protected $indexOptions = [
        'permalink' => false,
        'create' => false,
        'edit' => false,
        'publish' => false,
        'bulkPublish' => false,
    ];

    protected $titleColumnKey = 'email';

    /**
     * Handle a email submit request for the application.
     *
     * @param  \App\Http\Requests\Admin\ContactEmailRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function submitEmail(ContactEmailRequest $request)
    {
        $data = $request->validated();

        return DB::transaction(function () use ($data) {
            ContactEmail::create([
                'email' => $data['email'],
            ]);

            return (new JsonResponse)->setStatusCode(201);
        });
    }
}
