<?php

namespace App\Http\Requests\Web;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => ['required', 'string', 'max:191'],
            'last_name' => ['required', 'string', 'max:191'],
            'email' => ['required', 'string', 'email:rfc,filter', 'max:191', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'description' => ['string', 'max:191'],
            'author_name' => ['string', 'max:191'],
            'birth_date' => ['required', 'string', 'max:191'],
        ];
    }
}
