<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AbstractModel extends Model
{
    use HasFactory;

    /** @var array */
    public const LITERARY_FORM_LIST = [
        'Correspondances',
        'Journaux',
        'Editoriaux',
        'Chroniques',
        'Manuels',
        'Tuto Mode d’emploi',
        'Dictionnaires',
        'Biographies—autobiographies',
        'Essais',
        'Contes philosophiques',
        'Pamphlets',
        'Fables',
        'Romans Feuilletons',
        'Pièces de',
        'théâtre',
        'Poèmes',
        'Nouvelles',
        'Scripts',
        'Contes',
        'Bandes dessinées',
        'Autre',
    ];

    protected $fillable = [
        'user_id',
        'title',
        'literary_form',
        'register',
        'theme',
        'approve',
    ];

    public function user() : BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
