<?php

namespace App\Models;

use A17\Twill\Models\Model;
use A17\Twill\Models\Behaviors\HasFiles;
use A17\Twill\Models\Behaviors\HasBlocks;
use A17\Twill\Models\Behaviors\HasPresenter;
use App\Models\Presenters\UserAbstractPresenter;
use Illuminate\Database\Eloquent\Relations\HasOne;

class UserAbstract extends Model
{
    use HasBlocks;
    use HasFiles;
    use HasPresenter;

    /** @var array */
    protected $fillable = [
        'published',
        'story_title',
        'literary_form',
        'register',
        'theme',
        'text',
        'is_approved',
        'explanatory',
    ];

    /** @var array */
    public array $filesParams = ['abstract'];

    /**
     * The presenter the resource corresponds to.
     *
     * @var string
     */
    protected $presenterAdmin = UserAbstractPresenter::class;

    public function user() : HasOne
    {
        return $this->hasOne(User::class);
    }
    
    public function toDataObjectArray() : array
    {
        return [
            'storyTitle' => $this->story_title,
            'literaryForm' => $this->literary_form,
            'register' => $this->register,
            'theme' => $this->theme,
            'isApproved' => $this->is_approved,
            'explanatory' => $this->explanatory,
            'text' => $this->text,
        ];
    }
}
