<?php

namespace App\Models;

use A17\Twill\Models\Model;
use A17\Twill\Models\Behaviors\HasFiles;
use App\Models\Presenters\UserManuscriptPresenter;
use Illuminate\Database\Eloquent\Relations\HasOne;

class UserManuscript extends Model
{
    use HasFiles;

    /** @var array */
    protected $fillable = [
        'published',
        'title',
        'is_approved',
        'explanatory',
    ];

    /** @var array */
    public array $filesParams = ['manuscript'];

    /**
     * The presenter the resource corresponds to.
     *
     * @var string
     */
    protected $presenterAdmin = UserManuscriptPresenter::class;

    public function user() : HasOne
    {
        return $this->hasOne(User::class);
    }

    public function toDataObjectArray() : array
    {
        return [
            'title' => $this->title,
            'isApproved' => $this->is_approved,
            'explanatory' => $this->explanatory,
        ];
    }
}
