<?php

namespace App\Models;

use A17\Twill\Models\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class UserParentsContact extends Model
{
    /** @var array */
    protected $fillable = [
        'published',
        'title',
        'contact_person_email',
        'phone',
        'is_approved',
    ];
    
    public function user() : HasOne
    {
        return $this->hasOne(User::class);
    }
    
    public function toDataObjectArray() : array
    {
        return [
            'title' => $this->title,
            'contactPersonEmail' => $this->contact_person_email,
            'phone' => $this->phone,
            'isApproved' => $this->is_approved,
        ];
    }
}
