<?php

namespace App\Repositories;

use Illuminate\Support\Collection;
use A17\Twill\Repositories\ModuleRepository;
use App\Models\Collection as CollectionModel;
use A17\Twill\Repositories\Behaviors\HandleBlocks;
use A17\Twill\Repositories\Behaviors\HandleMedias;

class CollectionRepository extends ModuleRepository
{
    use HandleBlocks;
    use HandleMedias;

    public function __construct(CollectionModel $model)
    {
        $this->model = $model;
    }

    public function getHomeCollections() : Collection
    {
        return $this->model
            ->where('display_homepage', 1)
            ->published()
            ->get();
    }

    public function getAll() : Collection
    {
        return $this->model
            ->published()
            ->get();
    }
}
