<?php

namespace App\Repositories;

use App\Models\Extrait;
use Illuminate\Support\Collection;
use A17\Twill\Repositories\ModuleRepository;
use A17\Twill\Repositories\Behaviors\HandleFiles;
use A17\Twill\Repositories\Behaviors\HandleSlugs;
use A17\Twill\Repositories\Behaviors\HandleBlocks;
use A17\Twill\Repositories\Behaviors\HandleMedias;
use A17\Twill\Repositories\Behaviors\HandleRevisions;

class ExtraitRepository extends ModuleRepository
{
    use HandleBlocks;
    use HandleSlugs;
    use HandleMedias;
    use HandleFiles;
    use HandleRevisions;

    public function __construct(Extrait $model)
    {
        $this->model = $model;
    }

    public function getAll() : Collection
    {
        return $this->model->get();
    }

    public function getByCollection(int $collectionId) : Collection
    {
        return $this->model
            ->where('collection_id', $collectionId)
            ->published()
            ->get();
    }
}
