<?php

namespace App\Repositories;

use Carbon\Carbon;
use App\Models\News;
use Illuminate\Support\Collection;
use A17\Twill\Repositories\ModuleRepository;
use A17\Twill\Repositories\Behaviors\HandleFiles;
use A17\Twill\Repositories\Behaviors\HandleBlocks;
use A17\Twill\Repositories\Behaviors\HandleMedias;

class NewsRepository extends ModuleRepository
{
    use HandleBlocks;
    use HandleMedias;
    use HandleFiles;

    public function __construct(News $model)
    {
        $this->model = $model;
    }

    public function getHomeNews() : Collection
    {
        return $this->model
            ->published()
            ->get();
    }

    public function prepareFieldsBeforeSave($object, $fields)
    {
        if (isset($fields['published']) && $fields['published'] && (! isset($fields['posted_at']) || (isset($fields['posted_at']) && ! $fields['posted_at']))) {
            $fields['posted_at'] = Carbon::now('Europe/Paris')->format('Y-m-d H:i:s');
        }

        return parent::prepareFieldsBeforeSave($object, $fields);
    }
}
