<?php

namespace App\Repositories;

use App\Models\Testimonial;
use Illuminate\Support\Collection;
use A17\Twill\Repositories\ModuleRepository;
use A17\Twill\Repositories\Behaviors\HandleBlocks;
use A17\Twill\Repositories\Behaviors\HandleMedias;

class TestimonialRepository extends ModuleRepository
{
    use HandleBlocks;
    use HandleMedias;

    public function __construct(Testimonial $model)
    {
        $this->model = $model;
    }

    public function getHomeTestimonies() : Collection
    {
        return $this->model
            ->where('display_homepage', 1)
            ->published()
            ->get();
    }

    public function getByCollection(int $collectionId) : Collection
    {
        return $this->model
            ->where('collection_id', $collectionId)
            ->published()
            ->get();
    }
}
