<?php

namespace App\Repositories;

use App\Models\UserAbstract;
use A17\Twill\Repositories\ModuleRepository;
use App\Notifications\VerifyChapterTwoEmail;
use App\Notifications\DeclineChapterTwoEmail;
use A17\Twill\Repositories\Behaviors\HandleFiles;
use A17\Twill\Repositories\Behaviors\HandleBlocks;

class UserAbstractRepository extends ModuleRepository
{
    use HandleBlocks;
    use HandleFiles;

    public function __construct(UserAbstract $model)
    {
        $this->model = $model;
    }

    /**
     * @param \A17\Twill\Models\Model $object
     * @param array $fields
     *
     * @return string[]
     */
    public function prepareFieldsBeforeSave($object, $fields)
    {
        if (! $object->wasRecentlyCreated && $fields['is_approved'] === '1') {
            /* @phpstan-ignore-next-line */
            $object?->user->notify(new VerifyChapterTwoEmail);
        } elseif (! $object->wasRecentlyCreated && $fields['is_approved'] === '0') {
            /* @phpstan-ignore-next-line */
            $object?->user->notify(new DeclineChapterTwoEmail);
        }

        // Call parent function to finish this save action
        return parent::prepareFieldsBeforeSave($object, $fields);
    }
}
