<?php

namespace App\Responses\HttpResponses;

use Illuminate\Http\JsonResponse;

final class DataResponse extends JsonResponse
{
    public function __construct(array $data, int $code = 200, array $headers = [])
    {
        parent::__construct([
            'data' => $data,
        ], $code, $headers);
    }

    public static function make(array $data, int $code = 200, array $headers = []) : DataResponse
    {
        return new self($data, $code, $headers);
    }
}
