<?php

namespace App\Responses\HttpResponses;

use Illuminate\Http\Response;
use Illuminate\Http\JsonResponse;

class HttpResponse extends Response
{
    public function __construct(mixed $content, int $code = 200, array $headers = [])
    {
        parent::__construct($content, $code, $headers);
    }

    /**
     * Make response
     *
     * @param string $message
     * @param integer $code
     * @param array $headers
     *
     * @return \App\Responses\HttpResponses\HttpResponse|\Illuminate\Http\JsonResponse
     */
    public static function makeMessage(string $message = null, int $code = 200, array $headers = []) : mixed
    {
        return $message === null ? new self(null, $code) : new \Illuminate\Http\JsonResponse([
            'message' => $message,
        ], $code, $headers);
    }

    public static function json(array $data, int $code = 200, array $headers = []) : JsonResponse
    {
        return new JsonResponse($data, $code, $headers);
    }

    public static function response(mixed $content, int $code = 200, array $headers = []) : HttpResponse
    {
        return new self($content, $code, $headers);
    }
}
