<?php

namespace App\Responses\Responsables;

use League\Fractal\Resource\Item;
use League\Fractal\Resource\Collection;
use League\Fractal\TransformerAbstract;

abstract class ModelResponse extends ResponseWithManager
{
    abstract public function getModelTransformer() : TransformerAbstract;

    /**
     * Get the name of the property that'll wrap
     * the response.
     * It's usually 'data' (default value)
     *
     * @return string
     */
    public function getDataPropertyName() : ?string
    {
        return 'data';
    }

    /**
     * Create a response that returns JSON data.
     *
     * @param mixed $item
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toJsonResponse($item)
    {
        $resource = new Item($item, $this->getModelTransformer(), $this->getDataPropertyName());

        return $this->createData($resource)->toArray();
    }

    /**
     * Create a response that returns JSON data.
     *
     * @param mixed $collection
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toJsonCollectionResponse($collection)
    {
        $response = new Collection($collection, $this->getModelTransformer(), $this->getDataPropertyName());

        return $this->createData($response)->toArray();
    }
}
