<?php

namespace App\Responses\Responsables;

use League\Fractal\Resource\Collection;
use League\Fractal\Pagination\IlluminatePaginatorAdapter;

abstract class PaginableModelResponse extends ModelResponse
{
    /**
     * Create a response that returns JSON data.
     *
     * @param mixed $collection
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toJsonCollectionResponse($collection)
    {
        $perPage = request()->query('perPage', request()->query('limit', '16'));
        $paginator = $collection->paginate($perPage)->appends(['perPage' => $perPage]);
        $paginated_collection = $paginator->getCollection();

        $resource = new Collection($paginated_collection, $this->getModelTransformer(), $this->getDataPropertyName());
        $response = $resource->setPaginator(new IlluminatePaginatorAdapter($paginator));

        return $this->createData($response)->toArray();
    }
}
