<?php

namespace App\ViewModels;

use JsonSerializable;
use Illuminate\Http\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Spatie\ViewModels\ViewModel as BaseViewModel;

abstract class ViewModel extends BaseViewModel
{
    public function toResponse($request) : Response
    {
        if ($request->wantsJson()) {
            if ($this instanceof JsonSerializable) {
                return (new JsonResponse($this))->setVary('Accept', true);
            }

            return (new JsonResponse($this->items()))->setVary('Accept');
        }

        if ($this->view) {
            /* @phpstan-ignore-next-line */
            return response()->view($this->view, $this)->setVary('Accept');
        }

        return (new JsonResponse($this instanceof JsonSerializable ? $this : $this->items()))
            ->setVary('Accept');
    }
}
