<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCollectionsTables extends Migration
{
    public function up()
    {
        Schema::create('collections', function (Blueprint $table) {
            createDefaultTableFields($table);
            $table->string('title', 200);
            $table->text('content')->nullable();
            $table->string('author', 30)->nullable();
            $table->boolean('display_homepage')->nullable();
            $table->unsignedInteger('position')->nullable();
            ;
        });
    }

    public function down()
    {
        Schema::dropIfExists('collections');
    }
}
