@php
    $collectionOptions = array();
    if (count($collections) > 0) {
        foreach ($collections as $collection) {
            array_push($collectionOptions, array(
                'value' => $collection->id,
                'label' => $collection->title,
            ));
        }
    }
@endphp

@extends('twill::layouts.form')
@section('contentFields')
    @formField('wysiwyg', [
        'name' => 'content',
        'label' => __('admin/homepage.content'),
        'toolbarOptions' => [
            'bold',
            'italic',
            'blockquote',
            'link',
            'clean',
        ],
        'maxlength' => 2200,
        'rows' => 40,
    ])

    @formField('input', [
        'name' => 'author',
        'label' => __('admin/homepage.author'),
        'maxlength' => 100,
    ])

    @formField('select', [
        'name' => 'collection_id',
        'label' => __('admin/homepage.collection'),
        'placeholder' => __('admin/homepage.select_collection'),
        'options' => $collectionOptions,
    ])
@stop
