@if (count($newsList) > 0)
<section id="news-wrapper" class="py-14 md:py-24">
    <div class="container">
        <!-- Begin Custom Nav Arrows -->
        <div class="md:flex md:justify-between mb-0 lg:mb-8 ">
            <h2 class="font-extrabold text-4xl font-HeptaSlab md:text-left text-center">Actualités</h2>
            <ul class="custom-slick-arrows hidden md:block">
                <li class="custom-prev-button"></li>
                <li class="custom-next-button"></li>
            </ul>
        </div>
        <!-- End Custom Nav Arrows -->

        <!-- Begin Slider -->
        <div class="py-14 slider md:-mx-5">
            @foreach ($newsList as $news)
            <a class="px-5" href="{{ route('web.news.show', [$news->id]) }}">
                <img src="{{ $news->image('cover', 'default') }}" class="mb-5 rounded-xl" alt="{{ $news->title }}" loading="lazy" />
                <h5 class="font-HeptaSlab font-extrabold text-2xl md:h-20">{{ $news->title }}</h5>
                <div class="text-sm">{!! $news->summary !!}</div>
            </a>
            @endforeach
        </div>
        <!-- End Slider -->
    </div>
</section>
@endif

@section('js')
    @parent
    <script>
        $("#news-wrapper .slider").slick({
            infinite: false,
            slidesToShow: 3,
            prevArrow: $('#news-wrapper .custom-prev-button'),
            nextArrow: $('#news-wrapper .custom-next-button'),
            responsive: [{

                breakpoint: 1024,
                settings: {
                    slidesToShow: 3,
                    infinite: true
                }
            }, {

                breakpoint: 768,
                settings: {
                    slidesToShow: 2,
                    dots: true
                }

            }, {

                breakpoint: 576,
                settings: {
                    slidesToShow: 1,
                    dots: true
                }
            }]
        });
    </script>
@endsection