<div class="step-content register-step" step-order="8" data-chapter="4" style="display: none;">
    <h2 class="font-HeptaSlab font-extrabold text-6xl mb-2.5">Chapitre 4</h2>
    <h4 class="font-HeptaSlab font-medium text-3xl mb-2.5">Premier contact</h4>
    <form>
        <p class="text-sm font-medium mb-5">
            Maintenant que ton manuscrit est validé par notre comité de lecture, nous allons maintenant l’éditer ensemble en vue de le publier.
            <br />
            Avant cela, nous devons t’assurer du travail que nous allons faire, et aussi, fixer les modalités relatives à tes droits d’auteur.
            @if (Auth::check() && $user->age() < 18)
                <br />
                Comme tu n’as pas encore atteint l’âge légal de la majorité (moi non plus ;) ), je te propose que mon papa se charge de tous ces aspects avec tes représentants légaux.
            @endif
        </p>
        <input type="hidden" name="user_age" value="{{ Auth::check() ? $user->age() : null }}" />
        
        <div class="flex items-center border-t border-b py-7 my-7">
            <img src="{{ asset('images/statics/illustration-pierre.png') }}" class="mr-5" width="80px" height="80px" loading="lazy" />
            <p>
            </p>
        </div>
        @if (Auth::check() && $user->age() < 18)
        <div class="p-5 shadow-2xl rounded-lg bg-purple font-medium text-sm text-white">
            Il est indispensable que nous contactions tes responsables légaux avant de passer au chapitre suivant. Renseigne les informations ci-dessous avant de continuer.
        </div>

        <div class="grid grid-cols-2 gap-10 my-7">
            <div class="input-group">
                @include('web.components.forms.email', ['id' => 'contact_person_email', 'name' => 'contact_person_email', 'label' => 'Email de la personne à contacter', 'value' => isset($user) && $user->userParentsContact ? $user->userParentsContact->contactPersonEmail : '', 'placeholder' => '', 'required' => true, 'readOnly' => isset($user) && $user->userParentsContact ? true : false])
            </div>

            <div class="input-group">
                @include('web.components.forms.tel', ['id' => 'phone', 'name' => 'phone', 'label' => 'Téléphone (facultatif)', 'value' => isset($user) && $user->userParentsContact ? $user->userParentsContact->phone : '', 'placeholder' => '', 'required' => false, 'readOnly' => isset($user) && $user->userParentsContact ? true : false])
            </div>
        </div>
        @include('web.components.forms.checkbox', ['name' => 'accept_contact', 'label' => 'J’accepte que mes responsables légaux soient contactés par l’équipe Stencil', 'value' => '', 'checked' => isset($user) && $user->userParentsContact ? true : false])
        @endif
    </form>
    <div class="errors-container"></div>
    @include('web.components.register.step-nav', ['step' => 5])
</div>
