<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Web\HomeViewAction;
use App\Http\Controllers\Web\NewsController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Web\CollectionController;
use App\Http\Controllers\Web\SubscriptionController;
use App\Http\Controllers\Admin\ContactEmailController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\ForgotPasswordController;

Auth::routes(['verify' => true]);

Route::name('web.')->group(function () {
    /* Home */
    Route::get('/', HomeViewAction::class)->name('index');

    /* Sign in */
    Route::post('/login', [LoginController::class, 'login'])->name('login');
    
    /* Sign up */
    Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register.index');
    Route::post('/register', [RegisterController::class, 'register'])->name('register');

    /* Password reset */
    Route::post('/password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::post('/password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');

    Route::post('/submit-abstract', [RegisterController::class, 'submitAbstract'])->name('register.abstract');
    Route::post('/refuse-abstract', [RegisterController::class, 'refuseAbstract'])->name('register.refuse_abstract');
    
    Route::post('/submit-manuscript', [RegisterController::class, 'submitManuscript'])->name('register.manuscript');
    Route::post('/refuse-manuscript', [RegisterController::class, 'refuseManuscript'])->name('register.refuse_manuscript');
    Route::post('/submit-parents-contact', [RegisterController::class, 'submitParentsContact'])->name('register.parents-contact');

    /* Sign out */
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    /* Collections */
    Route::get('/collections', [CollectionController::class, 'index'])->name('collections.index');
    Route::get('/collections/{collection}', [CollectionController::class, 'show'])->name('collections.show');
    Route::post('/collections/{collection}/testimonials', [CollectionController::class, 'getTestimonials'])->name('collections.testimonials');

    Route::post('/collections/{collection}/extraits', [CollectionController::class, 'getExtraits'])->name('collections.extraits');

    /* News */
    Route::get('/news/{news}', [NewsController::class, 'show'])->name('news.show');

    /* About */
    Route::get('/about', [HomeViewAction::class, 'about'])->name('about.index');

    /* Our Values */
    Route::get('/our-values', [HomeViewAction::class, 'ourValues'])->name('our_values.index');

    /* Subscription */
    Route::get('/subscription', SubscriptionController::class)->name('subscription.index');

    Route::post('/submit-contact-email', [ContactEmailController::class, 'submitEmail'])->name('contact.email');
});
