<?php

namespace Tests\Feature\Http\Requests\Api\V1\Users;

use Tests\TestCase;
use App\Models\User;

class UserIndexTest extends TestCase
{
    /**
     * Set up test
     *
     * @return void
     */
    protected function setUp() : void
    {
        parent::setUp();
    }

    /**
     * Test it_checks_response_matches
     *
     * @test
     */
    public function it_checks_response_matches()
    {
        $user = User::factory(3)
            ->create();
        $match = [
            'data' => [
                '*' => [
                    'id',
                    'full_name',
                    'first_name',
                    'last_name',
                    'email',
                ],
            ],
        ];
        $response = $this->withInstallationHeader(null, $user)->getJson(route('api.v1.users.index'));
        $response->assertStatus(200);
        $response->assertJsonStructure($match);
    }
}
