<?php

namespace Tests\Unit\Responses\Api\V1;

use Tests\TestCase;
use App\Models\User;
use App\Responses\Responsables\Api\V1\UserResponse;

class UserResponseTest extends TestCase
{
    /**
     * Set up test
     *
     * @return void
     */
    protected function setUp() : void
    {
        parent::setUp();
    }

    /**
     * Test it_checks_response_matches
     *
     * @test
     */
    public function it_checks_response_matches()
    {
        $user = User::factory()
            ->create([
                'email' => 'test@appsolute.fr',
            ]);
        $match = [
            'data' => [
                'id',
                'full_name',
                'first_name',
                'last_name',
                'email',
            ],
        ];
        $this->assertResponsable(new UserResponse($user), $match);
    }
}
